//
//  NSColor+MCAAdditions.h
//  MCApplication
//
//  Created by Michael Clark on 11/01/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSColor (MCAAdditions)

+ (NSColor*)mcColorWithRed:(float)red green:(float)green blue:(float)blue alpha:(float)alpha;

//// Makes the color have no transparency
+ (NSColor*)mcColorWithRed:(int)red green:(int)green blue:(int)blue;

// Adds the color deltas to the components and returns the resulting image
- (NSColor*)colorByAddingToRed: (int)red_delta green: (int)green_delta blueComponents: (int)blue_delta;

// Multiplies the RGB values with the given percentages  as decimal, i.e. 75% is .75
- (NSColor*)colorAsPercentagesOfRed: (float)red_percent green: (float)green_percent blueComponents: (float)blue_percent;

// Returns a color that, should it be deemed difficult to read/invisible on a white background, will compensate by adding some grey
- (NSColor *)whiteSafeColor;

// Returns either white or black, will return black if the reciever is too bright
- (NSColor *)readableTextColor;

// pastes the color on top of white, so that if the color has alpha, it will blend with the white
// this then gets the rgb values for that resulting blended color and makes a new color out of them, with no transparency
- (NSColor *)colorByMakingOpaqueOnWhite;

// Color bead
- (NSImage *)colorBlobImage;

// RGB 8-bit components (i.e. between 0 and 255)
- (int)redComponentAs8BitRGB;
- (int)greenComponentAs8BitRGB;
- (int)blueComponentAs8BitRGB;
@end
